#include <iostream>
#include <bits/stdc++.h>

using namespace std;

template <int maxn> struct segtree{
    struct node{
        int m;
        int c;
        node(int br = INT32_MAX, int v = 0){
            m = br;
            c = v;
        }

        node& operator+=(node other){
            if(m > other.m) c = other.c;
            m = min(m, other.m);

            return *this;
        }
        node operator+(node other){
            node tmp = *this;
            return tmp+= other;
        }
    };

    node a[2*maxn];

    void init(vector<pair<int, int>> s){
        for(int i = 0; i < maxn; i++){
            a[i+maxn] = node();
        }
        for(int i = 0; i < s.size(); i++){
            a[i+maxn] = node(s[i].first, s[i].second);
        }

        for(int i = maxn-1; i > 0; i--){
            a[i] = a[2*i] + a[2*i+1];
        }
    }
    node get(int l, int r, int pos = 1, int gl = 1, int gr = maxn){
        if(l > gr || r < gl) return node();
        if(l <= gl && r >= gr) return a[pos];

        int mid = (gl+gr)/2;

        return get(l, r, 2*pos, gl, mid) + get(l, r, 2*pos+1, mid+1, gr);
    }
};
segtree<(1 << 19)> drvo;

vector<vector<int>> e;
vector<bool> vis;
vector<int> cvorovi, d;
vector<pair<int, int>> lca;

void dfs(int v){
    vis[v] = true;
    //cout << v << endl;

    if(e[v].size() == 1 && v != 0){
        lca.push_back(make_pair(d[v], v));
        if(cvorovi[v] == -1) cvorovi[v] = lca.size()-1;
    }
    for(int i = 0; i < e[v].size(); i++){
        if(!vis[e[v][i]]){
            d[e[v][i]] = d[v]+1;
            lca.push_back(make_pair(d[v], v));
            if(cvorovi[v] == -1) cvorovi[v] = lca.size()-1;
            dfs(e[v][i]);
        }
    }
}

void Putevi(int N, int M, int Q, int* U, int* V, int* W, int* X, int* Y, int* Ans){
    if(M == N-1){
        e.assign(N, vector<int> (0));
        cvorovi.assign(N, -1);
        vis.assign(N, false);
        d.assign(N, 0);

        for(int i = 1; i <= M; i++){
            e[U[i]-1].push_back(V[i]-1);
            e[V[i]-1].push_back(U[i]-1);
        }

        dfs(0);

        drvo.init(lca);

        Ans = new int[Q+1];
        for(int i = 0; i < Q; i++){
            auto r = drvo.get(cvorovi[X[i+1]-1]+1, cvorovi[Y[i+1]-1]+1);
            Ans[i+1] = d[r.c]+1;
        }
        return;
    }
    else return;
}